#ifndef _ERRORCODES_H
#define _ERRORCODES_H

#include "UnityNP.h"

namespace UnityPlugin
{
	// Unity NP error codes for returning to scripts.
	// NOTE, if changing this enum you need to make the same changes to the enum in UnityNpToolkit\Assemblies\SonyNP\ErrorCodes.cs
	enum ErrorCode
	{
		NP_OK,
		NP_SIGNED_IN_FLIGHT_MODE,				// Sign in was successful but the Vita is in flight mode.
		NP_ERR_BUSY,							// A service is busy so cannot accept the request.
		NP_ERR_FAILED,							// General failure, check the log for more info.
		NP_ERR_NOT_SUPPORTED,					// Not supported on this platform.
		NP_ERR_BAD_STATE,						// Somethings gone wrong with the logic, most likely a bug in the UnityNpToolkit code.
		NP_ERR_NOT_SIGNED_IN,					// User is not signed in.
		NP_ERR_NOT_CONNECTED,					// No network connection.
		NP_ERR_NOT_CONNECTED_FLIGHT_MODE,		// No network connection, flight mode is enabled.
		NP_ERR_INDEX_OUT_OF_RANGE,				// An out of range array index was specified.
		NP_ERR_AUTH_NO_CACHED_TICKET,			// A ticket has not yet been cached.
		NP_ERR_TUS_NO_VAR_DATA,					// Getting a cached TUS variable but the variable data does not exist.
	};

	PRX_EXPORT bool PrxGetLoggingEnabled();
	PRX_EXPORT void PrxSetLoggingEnabled(bool enabled);

	// Helper functions, translates an sceError into an ErrorCode and logs.
	ErrorCode ProcessSceResult(int sceError, bool log, const char* className, const char* function, int line, const char* message);
	ErrorCode ProcessSceResult(int sceError, bool log, const char* message);
	ErrorCode ProcessSceResult(int sceError, bool log);

	// Helper functions, logs an ErrorCode.
	ErrorCode ProcessResult(ErrorCode error, bool log, const char* className, const char* function, int line, const char* message);
	ErrorCode ProcessResult(ErrorCode error, bool log, const char* message);
	ErrorCode ProcessResult(ErrorCode error, bool log);

	// Lookup an error and return a string version.
	const char* LookupErrorCode(ErrorCode errorCode);

	// Translate an SCE error code into a Unity NP error code.
	ErrorCode TranslateSceError(int sceErrorCode);

	// Lookup an SCE error and return a string version.
	const char* LookupSceErrorCode(int errorCode);

	class ResultCode
	{
	public:
		const char* m_className;
		ErrorCode m_LastError;
		int m_LastErrorSCE;

	public:
		ResultCode(const char* className);

		ErrorCode GetResult() const { return m_LastError; }
		int GetResultSCE() const { return m_LastErrorSCE; }
		void Reset() { m_LastError = NP_OK; m_LastErrorSCE = 0; }

		ErrorCode SetResultSCE(int sceErrorCode, bool log, const char* function, int line, const char* message=NULL);
		ErrorCode SetResultSCE(int sceErrorCode, bool log, const char* message);
		ErrorCode SetResultSCE(int sceError, bool log);
		ErrorCode SetResult(ErrorCode errorCode, int sceError, bool log, const char* function, int line, const char* message=NULL);
		ErrorCode SetResult(ErrorCode errorCode, bool log, const char* function, int line, const char* message=NULL);
		ErrorCode SetResult(ErrorCode errorCode, bool log, const char* message);
		ErrorCode SetResult(ErrorCode errorCode, bool log);
	};

}

#endif // _ERRORCODES_H
